/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

#include <sys/ddi.h>
#include <sys/sunddi.h>

/*
 * This is the loadable module wrapper.
 */
#include <sys/modctl.h>

extern struct mod_ops mod_miscops;

/*
 * Module linkage information for the kernel.
 */ 

static struct modlmisc modlmisc = {
  &mod_miscops,
  "mx mcp",
};

static struct modlinkage modlinkage = {
  MODREV_1,
  {(void *)&modlmisc,  NULL}
};

int _init(void)
{
  int i;
  
  if ((i = mod_install(&modlinkage)) != 0)
    cmn_err(CE_NOTE,"mx_mcp_wrapper: Could not install module\n");
  else
    cmn_err(CE_NOTE,"mx_mcp_wrapper: successfully installed");
  
  return i;
}

int _fini(void)
{
  int i;
  
  if ((i = mod_remove(&modlinkage)) != 0)
    cmn_err(CE_NOTE,"mx_mcp_wrapper: Could not remove module\n");
  else
    cmn_err(CE_NOTE,"mx_mcp_wrapper: successfully removed");
  
  return i;
}

int _info(struct modinfo *modinfop)
{
  return (mod_info(&modlinkage, modinfop));
}

